-- events for picture game


MAX_VISIONS = 7;


function OnLoad ()
	CacheSound ("music/picturegame.ogg");
	CacheFX ("fxs/minigame-hint.lua");
	CacheFX ("fxs/hidden-marker-added.lua");
end;

timer = 0;
new_vision_fade_in = 0;
time_end_timer = 0;
ai_click_timer = 0;
hint_timer = 0;
clicked_tip2 = false;
		
function RandomizeNewVision ()

	escape = false;
	while (not escape) do

		local old_x = Azkend_GetVisionX ();
		local old_y = Azkend_GetVisionY ();

		local y = math.random (50, 500);
		if (episode == 1 and Azkend_GetCurrentVisionNum () < 3) then
			y = math.random (50, 350);
		end;

		local x = 100;
		if (y < 600-200-40) then
			x = math.random (50, 800-50);
		else
			x = math.random (190+40, 800-150-50);
		end;
		if (math.abs (old_x-x) > 100 and math.abs (old_y-y) > 100) then
			Azkend_CreateVision (x, y, "");
			escape = true;
		end;
		-- else randomize again
	end;
	new_vision_fade_in = 0;
end;


function FoundVision ()
	
	hint_timer = 0;
	local num = Azkend_GetCurrentVisionNum ();
	SetGameValue ("hidden_spot_found_" .. (num+1), true);
	NX_PlaySound ("sfx/flower.ogg");
end;


function GetCurrentVisionFoundTrans ()
	local num_found = Azkend_GetCurrentVisionNum ();
	return GetGameValue ("hidden_spot_timer_" .. (num_found+1));
end;

function Reset ()
end;

function OnEnter ()

	hint_timer = 0;
	time_end_timer = 0;
	ai_click_timer = 0;
	
	tip_fade_timer = 0;
	tip2_fade_timer = 0;
	clicked_tip = false;
	clicked_tip2 = false;

	-- need to offset by -1 because the real level is actually already completed
	level_number = GetGameValue ("level_number")-1;
	episode = math.floor (level_number/7);
	imagenumber = string.format("%04d", episode);
	imagename = "worldmap/backgrounds/bg-"..imagenumber..".jpg";
	Azkend_SetMenuBackground (imagename);
	
	--Azkend_ResetHiddenGame ();
	--SetProperty ("/:enter_trans_duration", 1);
	--SetProperty ("/:leave_trans_duration", 1);
	SwitchMusic ("music/picturegame.ogg", 2, 3);
	timer = 0;
	
	if (Azkend_GetCurrentVisionNum () < 1) then
		if (episode == 1) then
			Azkend_CreateVision (460, 462, "");
		else
			RandomizeNewVision ();
		end;
		PushScreen ("HiddenTutorialTips");
	else
			Azkend_CreateVision (Azkend_GetVisionX (), Azkend_GetVisionY (), "");
			clicked_tip = true;
	end;
end;

function OnLeave ()
end;



function OnClick (name)

	Print ("OnClick " .. name .. "\n");

		if (Azkend_GetCurrentVisionNum () >= 1 and episode == 1) then
			clicked_tip2 = true;
		end;

	if (name == "picture" and not AllVisionsFound () and Azkend_GetHiddenTimeLeft () > 0) then	
		local x = Azkend_GetVisionX ();
		local y = Azkend_GetVisionY ();

		local dx = x - NX_GetKeyState ("MOUSE_X");
		local dy = y - NX_GetKeyState ("MOUSE_Y");

		dist = math.sqrt (dx * dx + dy * dy);

		if (dist < 80) then
			if (Azkend_GetCurrentVisionNum () < 1 and episode == 1) then
				tip2_fade_timer = 0.001;
			else
				clicked_tip2 = true;
			end;
			FoundVision ();
			clicked_tip = true;
			if (Azkend_GetCurrentVisionNum () == 1 and episode == 1) then
				--tip2_fade_timer = 0;
			end;
	
		else
			if (clicked_tip) then
				Azkend_HiddenBadClick ();
			end;
		end;
		return;
	end;

	if (name == "Next") then	
		RandomizeNewVision ();
	end;


	if (name == "Continue") then	
		SwitchScreen ("MainMenu");
		return;
	end;	
		
	if (name == "Menu") then	
		PushScreen ("GamePopMenu");
		return;
	end;

	


end;


function AllVisionsFound ()
	if (Azkend_GetCurrentVisionNum () >=  MAX_VISIONS and
		GetGameValue ("hidden_spot_timer_" .. MAX_VISIONS) >= 1) then
		return true;
	else
		return false;
	end;
end;

function OnUpdate (tdelta)
	akey = GetActiveScreenAnimKey ();	
	alpha = GetActiveScreenTransPhase ();
	
	if (IsTopScreen (GetProperty ("/:name"))) then
		hint_timer = hint_timer + tdelta;
	end;
	
	if (hint_timer > 20) then
		hint_timer = -Azkend_GetCurrentVisionNum () * 5;
		local x = Azkend_GetVisionX ();
		local y = Azkend_GetVisionY ();
		SpawnFX ("fxs/minigame-hint.lua", x, y, 0, 0);
	end;
	
	if (alpha >= 1 and Azkend_AutoplayerActive ()) then
		ai_click_timer = ai_click_timer + tdelta;
		if (ai_click_timer > 3.4) then
			ai_click_timer = 0;
			
			FoundVision ();
			
			local y = math.random (50, 500);
			if (episode == 1 and Azkend_GetCurrentVisionNum () < 3) then
				y = math.random (50, 350);
			end;
	
			local x = 100;
			if (y < 600-200-40) then
				x = math.random (50, 800-50);
			else
				x = math.random (190+40, 800-150-50);
			end;
			
			--OnClick (x, y);
		end;
	end;
	
	if (alpha >= 1 and episode==1 and IsTopScreen ("HiddenWorld")) then
		
		if (not clicked_tip) then
			tip_fade_timer = tip_fade_timer + 2*tdelta;
		else
			tip_fade_timer = tip_fade_timer - 2*tdelta;
		end;
		
		tip_fade_timer = clamp (tip_fade_timer, 0, 1);

		if (clicked_tip2) then --Azkend_GetCurrentVisionNum () >= 2 and episode == 1) then
			tip2_fade_timer = tip2_fade_timer - 2 * tdelta;
			if (tip2_fade_timer > 1.5) then
				tip2_fade_timer = 1.5;
			end;
			if (tip2_fade_timer < 1) then
				tip2_fade_timer = 0;
			end;
		else
			if (tip2_fade_timer > 0) then
				tip2_fade_timer = tip2_fade_timer + 0.8 * tdelta;
			end;
		end;

		tip2_fade_timer = clamp (tip2_fade_timer, 0, 3);

	end;
	
	if (tip_fade_timer > 0) then
		SetProperty ("tip:visible", 1);
		SetProperty ("tip:active", 1);
		SetProperty ("tip:alpha", tip_fade_timer);	
	else
		SetProperty ("tip:visible", 0);
		SetProperty ("tip:active", 0);
	end;
	
	if (tip2_fade_timer <= 1) then
		SetProperty ("tip2:visible", 0);
		SetProperty ("tip2:active", 0);
		SetProperty ("tip2:alpha", 0);	
	elseif (tip2_fade_timer < 1.5) then
		SetProperty ("tip2:visible", 1);
		SetProperty ("tip2:active", 1);
		SetProperty ("tip2:alpha", 2*(tip2_fade_timer-1));	
	elseif (tip2_fade_timer < 2.5) then
		SetProperty ("tip2:visible", 1);
		SetProperty ("tip2:active", 1);
		SetProperty ("tip2:alpha", 1);	
	elseif (tip2_fade_timer < 7.0) then
		SetProperty ("tip2:visible", 1);
		SetProperty ("tip2:active", 1);
		SetProperty ("tip2:alpha", 1 - 2*(tip2_fade_timer-6.5));	
	else 
		SetProperty ("tip2:visible", 0);
		SetProperty ("tip2:active", 0);
		SetProperty ("tip2:alpha", 0);	
	end;

	if ((not AllVisionsFound ()) and IsTopScreen (GetProperty ("/:name")) and timer > 0.5) then
		Azkend_UpdateHiddenWorld (tdelta);
	end;
	
	
	timer = timer + tdelta;
	new_vision_fade_in = clamp (new_vision_fade_in + 5*tdelta, 0, 1);

	local offset = 10 * (1 + math.cos (timer*6));
	SetProperty ("arrow:position_offset.x", offset);
	--SetProperty ("arrow:position_offset.y", -offset);
	
	local num_found = Azkend_GetCurrentVisionNum ();
	local total = MAX_VISIONS;
	SetProperty ("progress:label.text", string.format ("%d / %d", num_found, total));

	if (num_found < MAX_VISIONS) then

		local t = GetCurrentVisionFoundTrans ();

		if (t >= 1) then

			SpawnFX ("fxs/hidden-marker-added.lua", GetMarkerX (num_found), GetMarkerY (num_found), 0, 0);
			Azkend_SetCurrentVisionFound ();
			RandomizeNewVision ();
		end;
	end;

	if (Azkend_GetHiddenTimeLeft () <= 0) then
		time_end_timer = clamp (time_end_timer + 1.0*tdelta, 0, 1);
	end;

	if (IsTopScreen (GetProperty ("/:name")) and AllVisionsFound ()) then
		--PushScreen ("HiddenObjectCompleted");
		PushScreen ("HiddenObjectTimeBonus");
	elseif (IsTopScreen (GetProperty ("/:name")) and time_end_timer >= 1) then --Azkend_GetHiddenTimeLeft () <= 0) then
		--PushScreen ("HiddenObjectCompleted");
		PushScreen ("HiddenObjectTimeBonus");
	end;
end;


function clamp (value, min_value, max_value)
	value = math.min (value, max_value);
	value = math.max (value, min_value);
	return value;
end;

function m_smooth (t)
	-- smooth the end
	t = math.sin (t * math.pi/2);
	-- smooth the start
	t = 1-math.cos (t * math.pi/2);
	return t;

end;

function GetMarkerX (i)
	local target_x = GetProperty ("flowers:static_position.x");

	local t = GetGameValue ("hidden_spot_timer_" .. (i+1));

	local rad = 84;
	local angle = 0.8+(2 * math.pi-0.8) * i / MAX_VISIONS - math.pi/2;

	return target_x + rad * math.cos (angle);
end;

function GetMarkerY (i)

	local target_y = GetProperty ("flowers:static_position.y");
	local t = GetGameValue ("hidden_spot_timer_" .. (i+1));
	local rad = 84;
	local angle = 0.8+(2 * math.pi-0.8) * i / MAX_VISIONS - math.pi/2;

	return target_y + rad * math.sin (angle);

end;


function OnDraw ()

	Azkend_DrawHiddenUI ();

	NX_SetAlpha (1);
	NX_SetBlend ("NORMAL");
	NX_SetColor (1,1,1);
	local target_x = GetProperty ("flowers:static_position.x");
	local target_y = GetProperty ("flowers:static_position.y");

	local num_found = Azkend_GetCurrentVisionNum ();

	local i;

	i = 0;
	local bm = "hidden/visions_slot.png";
	while (i < MAX_VISIONS) do

		local x = GetMarkerX (i);
		local y = GetMarkerY (i);

		NX_SetAlpha (1);
		NX_DrawBitmapRS (bm, x, y, angle, 1);

		i = i+1;
	end;

	i = 0;
	bm = "hidden/visions_light.png";
	while (i < num_found) do

		local t = GetGameValue ("hidden_spot_timer_" .. (i+1));

		local x = GetMarkerX (i);
		local y = GetMarkerY (i);

		NX_SetAlpha (clamp(t, 0, 1));
		NX_DrawBitmapRS (bm, x, y, angle, 1);

		i = i+1;
	end;

	NX_SetAlpha (new_vision_fade_in);
	NX_SetBlend ("NORMAL");
	NX_SetColor (1,1,1);

	local t = m_smooth (GetCurrentVisionFoundTrans ());
	local vision_x = target_x;
	local vision_y = target_y;
	local vision_scale = 1;
	local vision_angle = Azkend_GetVisionAngle ();

	if (t > 0 and t <= 1) then
		vision_x = (1-t) * vision_x + t * Azkend_GetVisionX ();
		vision_y = (1-t) * vision_y + t * Azkend_GetVisionY () - 150 * math.sin (math.pi*t);
		vision_angle = (1-t) * vision_angle;-- + math.pi * t * 2;
		vision_scale = vision_scale + 0.3 * math.sin (math.pi*t);
		SpawnFX ("fxs/dust-trail.lua", vision_x, vision_y, 0, 0);
	end;

	if (num_found >= MAX_VISIONS and t <= 0) then
		-- ...
	else
		NX_DrawBitmapRS ("VISION", vision_x, vision_y, vision_angle, vision_scale);
	end;


end;
